

#pragma once

typedef enum {
	cruntime=0,
	naive,
	kmp,
	boyermoore
} enumSearchAlgorithm;

// fastsearch ////////////////////////////////////////////////////
//
// provides facilities to search a string in a buffer
// provides API to select a best algorithm from
// searches one or more occurences
//
// Stephane Rodriguez- December 19, 2003
//
class fastsearch
{

	//
	// Members
protected:
	BOOL m_bUseCase;
	enumSearchAlgorithm m_nAlgorithm;
	LPTSTR	m_cpPtr;
	LPTSTR  m_cpPattern, m_cpBuffer;
	long* m_kmpNext; // KMP preprocessing (size is size of the pattern)
	long* m_bmGs; // Boyer Moore preprocessing (size is size of the pattern)
	long  m_bmBc[256]; // Boyer Moore preprocessing (size is the local charset (256). TODO : add MBCS/Unicode support)
	long  m_nBufferLen; // Boyer Moore preprocessing

	//
	// Construction
public:
	fastsearch();
	virtual ~fastsearch();

	//
	// Accessors
	//
	void SetCaseSensitive(BOOL bUseCase=TRUE);
	BOOL GetCaseSensitive();

	void SetAlgorithm(enumSearchAlgorithm alg);
	enumSearchAlgorithm GetAlgorithm();

	//
	// Methods
	//
	void Init(/*in*/LPTSTR pattern, /*in*/LPTSTR buffer);
	long Count(); // count all occurences
	LPTSTR First(); // find first occurence
	LPTSTR Next(); // find next occurence

	// Helpers
protected:
	void Forward(LPTSTR p); // forward cursor to look for next pattern
	void PreSearch();
	LPTSTR Search_CRuntime();
	LPTSTR Search_Naive();
	LPTSTR Search_KMP();
	LPTSTR Search_BM();
	void PostSearch();

	void RemoveKMP();
	void RemoveBoyerMoore();
};