
#include "stdafx.h"
#include "fastsearch.h"
#include "testcases.h"


long testcases()
{
	TCHAR buffer[100000];

	// fill the buffer from a sample file
	HANDLE fin = ::CreateFile("USERCTRL.htm",GENERIC_READ,FILE_SHARE_READ,NULL,
							OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
	if (fin == INVALID_HANDLE_VALUE)
	{
		::MessageBox(NULL,"file not found","error",MB_OK);
		return 0;
	}

	DWORD indexin = 0;
	DWORD dwRead = 0;
	::ReadFile(fin,buffer+indexin,4096,&dwRead,NULL);
	while ( dwRead > 0 )
	{
		indexin += dwRead;
		dwRead = 0;
		::ReadFile(fin,buffer+indexin,4096,&dwRead,NULL);
	}

	::CloseHandle(fin);



	LPTSTR pattern = "my pattern";

	fastsearch s;
	s.SetAlgorithm( cruntime );
	testsuite(s,buffer);

	s.SetAlgorithm( naive );
	testsuite(s,buffer);

	s.SetAlgorithm( kmp );
	testsuite(s,buffer);

	s.SetAlgorithm( boyermoore );
	testsuite(s,buffer);

	return 0;
}

void testsuite(fastsearch &s, LPTSTR buffer)
{
	DWORD dwStart = ::GetTickCount();

	long nbtimes = 100;

	long n1 = testcase1(s,buffer,nbtimes);
	long n2 = testcase2(s,buffer,nbtimes);
	long n3 = testcase3(s,buffer,nbtimes);
	long n4 = testcase4(s,buffer,nbtimes);
	long n5 = testcase5(s,buffer,nbtimes);

	DWORD dwEnd = ::GetTickCount();

	DWORD dwElapsed = dwEnd - dwStart;
	DWORD secs = dwElapsed / 1000;

	TCHAR sztmp[128];
	_stprintf(sztmp,"duration for alg(%d) test suite : %d msecs\r\n", s.GetAlgorithm(), dwElapsed);
	::OutputDebugString(sztmp);
}

// testcase1 : no match
long testcase1(fastsearch &s, LPTSTR buffer, long nbtimes)
{
	long nb = 0;

	for (long i = 0; i < nbtimes; i++)
	{
		LPTSTR pattern = "my pattern";
		s.Init(pattern,buffer);
		s.SetCaseSensitive(TRUE);
		nb = s.Count();
	}
	return nb;
}

// testcase2 : 1 match
long testcase2(fastsearch &s, LPTSTR buffer, long nbtimes)
{
	long nb = 0;

	for (long i = 0; i < nbtimes; i++)
	{
		LPTSTR pattern = "IPropertyBag";
		s.Init(pattern,buffer);
		s.SetCaseSensitive(TRUE);
		nb = s.Count();
	}
	return nb;
}


// testcase3 : some matches
long testcase3(fastsearch &s, LPTSTR buffer, long nbtimes)
{
	long nb = 0;

	for (long i = 0; i < nbtimes; i++)
	{
		LPTSTR pattern = "WebClient";
		s.Init(pattern,buffer);
		s.SetCaseSensitive(TRUE);
		nb = s.Count();
	}
	return nb;
}


// testcase4 : many matches
long testcase4(fastsearch &s, LPTSTR buffer, long nbtimes)
{
	long nb = 0;

	for (long i = 0; i < nbtimes; i++)
	{
		LPTSTR pattern = "developer";
		s.Init(pattern,buffer);
		s.SetCaseSensitive(TRUE);
		nb = s.Count();
	}
	return nb;
}


// testcase5 : many more matches
long testcase5(fastsearch &s, LPTSTR buffer, long nbtimes)
{
	long nb = 0;

	for (long i = 0; i < nbtimes; i++)
	{
		LPTSTR pattern = "the";
		s.Init(pattern,buffer);
		s.SetCaseSensitive(TRUE);
		nb = s.Count();
	}
	return nb;
}
