// favextractDlg.cpp : implementation file
//

#include "stdafx.h"
#include "favextract.h"
#include "favextractDlg.h"

#include "favorites.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


#define DUMMYITEMLABEL	_T("<dummy>")
#define URLICON			0
#define FOLDERICON		1


/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFavextractDlg dialog

CFavextractDlg::CFavextractDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CFavextractDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CFavextractDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CFavextractDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CFavextractDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CFavextractDlg, CDialog)
	//{{AFX_MSG_MAP(CFavextractDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_NOTIFY(TVN_ITEMEXPANDING, IDC_FAVTREE, OnTreeItemExpanding)
	ON_NOTIFY(NM_DBLCLK, IDC_FAVTREE, OnTreeDoubleClick)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFavextractDlg message handlers

BOOL CFavextractDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// initialize tree ctrl image list
	CBitmap my_bitmap;
	my_bitmap.LoadBitmap(IDB_FAVBITMAPS);

	m_imglist.Create(16, 16, ILC_COLOR8 | ILC_MASK, 2, 10);
	m_imglist.Add(&my_bitmap, RGB(255,0,255));

	CTreeCtrl* pTreeCtrl = (CTreeCtrl*) GetDlgItem(IDC_FAVTREE);

	pTreeCtrl->SetImageList(&m_imglist,TVSIL_NORMAL);


	// fill the tree ctrl with the first level of favorites
	//
	AddChildren( CString(_T("")), NULL);


	

	pTreeCtrl->Expand( pTreeCtrl->GetRootItem(), TVE_EXPAND);


	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CFavextractDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CFavextractDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CFavextractDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}



void CFavextractDlg::OnTreeItemExpanding(NMHDR *pnmh, LRESULT *pResult)
{
	CTreeCtrl* pTreeCtrl = (CTreeCtrl*) GetDlgItem(IDC_FAVTREE);
	if (!pTreeCtrl) return;

	NM_TREEVIEW *pnmtv=(NM_TREEVIEW *)pnmh;
	HTREEITEM hExpandingItem = pnmtv->itemNew.hItem;
	if (!hExpandingItem) return;

	if (pnmtv->action != TVE_EXPAND) // is being expanded
		return;

	// is there a <dummy> child?
	HTREEITEM hChildItem = pTreeCtrl->GetChildItem(hExpandingItem);
	if (!hChildItem)
		return;
	
	CString szChildName = pTreeCtrl->GetItemText(hChildItem);
	if ( szChildName.CompareNoCase(DUMMYITEMLABEL)==0  ) // there is 
	{
		// remove this child
		pTreeCtrl->DeleteItem(hChildItem);
		
		if (hExpandingItem && pTreeCtrl->GetParentItem(hExpandingItem))
		{
			LockWindowUpdate(); // CWnd member

			SetCursor(LoadCursor(NULL, IDC_WAIT)); // hourglass

			CString szPath = GetPathFromNode(hExpandingItem);
			AddChildren(szPath, hExpandingItem);

			SetCursor(LoadCursor (NULL, IDC_ARROW)); // back to normal cursor

			UnlockWindowUpdate();  // CWnd member
		}
	}
				
}


void CFavextractDlg::OnTreeDoubleClick(NMHDR * pNotifyStruct, LRESULT* pResult)
{
	CTreeCtrl* pTreeCtrl = (CTreeCtrl*) GetDlgItem(IDC_FAVTREE);
	if (!pTreeCtrl) return;

	// get the tree item that was double-clicked
	DWORD dwPos = ::GetMessagePos();
	CPoint point ( (int)LOWORD(dwPos),(int)HIWORD(dwPos));
	pTreeCtrl->ScreenToClient(&point);

	UINT nFlags;
	HTREEITEM hItem = pTreeCtrl->HitTest(point,&nFlags);
	if ( nFlags == TVHT_NOWHERE) return;

	// now do something with it
	// TODO
}





// helpers ///////////////////////////////////////////////////////////


CString CFavextractDlg::GetPathFromNode(HTREEITEM hItem)
{
	CTreeCtrl* pTreeCtrl = (CTreeCtrl*) GetDlgItem(IDC_FAVTREE);
	if (!pTreeCtrl) return _T("");

	if (hItem == NULL || pTreeCtrl->GetParentItem(hItem) == NULL) 
		return _T("");

	CString szPath;
	CString szCurKeyname;
	HTREEITEM hNextItem;

	while ( (hNextItem = pTreeCtrl->GetParentItem(hItem)) )
	{
		szCurKeyname = pTreeCtrl->GetItemText(hItem);
		if ( !szPath.IsEmpty() )
			szCurKeyname += "\\"; 

		szPath =  szCurKeyname + szPath;
		hItem = hNextItem; 
	} // end while

	return szPath;

}


// AddChildren
//
// Fill the tree ctrl with one level of favorites
//
// parameters : szPartialPath : empty is this is the root
//								path of the form Favorites\\Devnews
//				hParent			parent tree item
//
void CFavextractDlg::AddChildren(/*in*/CString &szPartialPath, HTREEITEM hParent)
{
	CTreeCtrl* pTreeCtrl = (CTreeCtrl*) GetDlgItem(IDC_FAVTREE);
	if (!pTreeCtrl) return;

	CFavorite* favs = NULL;

	CFavorites f;
	

	TCHAR szRegPath[MAX_PATH];
	TCHAR szFilePath[MAX_PATH];
	f.GetFavoritesRegPath(szRegPath);
	f.GetFavoritesFilePath(szFilePath);
	CString szFullRegPath = szRegPath;
	CString szFullFilePath = szFilePath;
	if ( !szPartialPath.IsEmpty() )
	{
		szFullRegPath += "\\" + szPartialPath;
		szFullFilePath += "\\" + szPartialPath;
	}
	else
	{
		// create tree root item
		if (!hParent)
		{
			long i = szFullFilePath.ReverseFind('\\');
			hParent = pTreeCtrl->InsertItem( szFullFilePath.Right( szFullFilePath.GetLength() - (i+1) ), 
											 FOLDERICON, FOLDERICON );
		}

	}

	f.ExtractFavorites(szFullRegPath.GetBuffer(0),
					   szFullFilePath.GetBuffer(0),
					   &favs, 
					   TRUE /*resolve url*/);

	if (!favs)
		return;

	CFavorite* p = favs;
	while ( p )
	{
		if (p->szPath[0] == 0)
			break; // no need to go further

		HTREEITEM hItem;
		
		// short filename
		CString s = _tcsrchr(p->szPath, '\\');
		if ( !s.IsEmpty() )
		{
			s = s.Right( s.GetLength() - 1);

			if ( p->bType ) // url
			{
				if (s.Right(4).CompareNoCase(".url") == 0) // remove .url suffix
					s = s.Left( s.GetLength() - 4);

				hItem = pTreeCtrl->InsertItem( s.GetBuffer(0),
									URLICON, 
									URLICON,
									hParent);
			}
			else // folder
			{
				hItem = pTreeCtrl->InsertItem( s.GetBuffer(0),
									FOLDERICON, 
									FOLDERICON,
									hParent);

				// if this is a folder, insert a dummy item only to ensure we have a [+] sign
				pTreeCtrl->InsertItem( DUMMYITEMLABEL,
									   URLICON,
									   URLICON,
									   hItem);
			}

		}

		p = p->pNext;
	} // for all favorites

	// delete the chain of favorites
	delete favs;
}

