

#include "stdafx.h"
#include <wininet.h> // INTERNET_MAX_URL_LENGTH
#include <intshcut.h>
#include "favorites.h"



// CFavorite class implementation //////////////////////////////////////////
//
//
//
CFavorite::CFavorite()
{
	pNext = NULL;
	*szPath = '\0';
	*szUrl = '\0';
}

CFavorite::CFavorite(CFavorite* pSrc)
{
	if (pSrc)
	{
		_tcscpy(szPath, pSrc->szPath);
		_tcscpy(szUrl, pSrc->szUrl);
	}
	else
	{
		*szPath = '\0';
		*szUrl = '\0';
	}

	bType = pSrc->bType;
	pNext = NULL;
}

CFavorite::~CFavorite()
{
	delete pNext; // delete the chain of favorites
	pNext = NULL;
}


BOOL CFavorite::FindOccurence(LPTSTR szPathToFind, CFavorite** ppLastFav)
{
	if (!ppLastFav) 
		return FALSE;

	CFavorite* p = this;
	CFavorite* pPrev = p;

	while (p)
	{
		if (_tcsicmp(p->szPath, szPathToFind) == 0)
		{
			*ppLastFav = pPrev;
			return TRUE;
		}

		pPrev = p;
		p = p ->pNext;

	} // end while

	*ppLastFav = pPrev;
	return FALSE;
}




// CFavorites class implementation //////////////////////////////////////////
//
//
//


CFavorites::CFavorites()
{
	// anticipate the use of a memory allocator
	::SHGetMalloc( &m_pMalloc );
	CheckOS();
}

CFavorites::~CFavorites()
{
	m_pMalloc->Release();
	m_pMalloc = NULL;
}


BOOL CFavorites::ExtractFavorites(CFavorite** ppFavorites,
								  BOOL bResolveUrl) // root level
{
	// open IE favorites, root level

	TCHAR szFavoriteRegPath[MAX_PATH] = "";
	TCHAR szFavoriteFilePath[MAX_PATH] = "";
	GetFavoritesRegPath(szFavoriteRegPath);
	GetFavoritesFilePath(szFavoriteFilePath);

	return ExtractFavorites(szFavoriteRegPath,
							 szFavoriteFilePath,
							 ppFavorites,
							 bResolveUrl);
}


BOOL CFavorites::ExtractFavorites(LPTSTR szRegKeyPath,
								  LPTSTR szFilePath,
								  CFavorite** ppFavorites,
								  BOOL bResolveUrl)
{
	HKEY hKey;
	LONG lRes = ::RegOpenKey(HKEY_CURRENT_USER, 
							szRegKeyPath, 
							&hKey);		
	if (lRes != ERROR_SUCCESS)
		return FALSE;

	BOOL bRes = ExtractFavorites(hKey,
					 szRegKeyPath,
					 szFilePath,
					 ppFavorites,
					 bResolveUrl);

	::RegCloseKey(hKey);

	return bRes;
}


BOOL CFavorites::ExtractFavorites(HKEY hParentKey,
								  LPTSTR szRegKeyPath,
								  LPTSTR szFilePath,
								  CFavorite** ppFavorites,
								  BOOL bResolveUrl) // another level
{
	// Extract sorted children (one level only) by 
	// reading the "Order" value of the current key

	DWORD nType;
	DWORD nLength = 0;
	// query for the length of the value
	::RegQueryValueEx(hParentKey, "Order", 0,
						&nType, 
						NULL,
						&nLength);

	BYTE* buffer = NULL;

	// does the "Order" value exist?
	if (nLength > 0)
	{
		buffer = (BYTE*) malloc( nLength + 1 );
		if (!buffer)
			return FALSE; // out of memory error

		if (::RegQueryValueEx(hParentKey, "Order", 0,	
							  &nType, buffer, &nLength) != ERROR_SUCCESS)
		{
			free(buffer);
			return FALSE;
		}
	}

	// do something with the value
	BOOL bRes = ExtractFavorites(hParentKey,
					 szRegKeyPath,
					 szFilePath,
					 ppFavorites,
					 bResolveUrl,
					 buffer,
					 nLength);


	if (buffer)
		free(buffer);

	return bRes;
}


//
// parses the structure format enclosed by the buffer.
// the buffer represents a level of sorted IE favorites
//
// Structure format =
// [Header] 20 bytes
// [Record1] variable length (24 + n bytes)
// [Record2] variable length (24 + n bytes)
// ...
// [Recordn] variable length (24 + n bytes)
//
//
// [Header] = 
// DWORD	4 bytes		00 00 00 08
// DWORD	4 bytes		---
// DWORD	4 bytes		total length of records in bytes, (includes the remaining bytes of this header, 12 bytes)
// DWORD	4 bytes		---
// DWORD	4 bytes		amount of records
//
// Windows 2000
// [
// [Record] =
// DWORD	4 bytes		length of record (those 4 bytes are included)
// DWORD	4 bytes		sorted index (0-based), special value : -5 if never sorted (appended at tail)
// WORD		2 bytes		key1
// WORD		2 bytes		key2
//							bit 1 = 1 (url) 0 (folder)
//							bit 2 = 1 (string 1 encoding = unicode) 0 (string 1 encoding = codepage)
// DWORD	4 bytes		---
// DWORD	4 bytes		id
// WORD		2 bytes		total length of following strings (2 bytes included)
// BYTE		n bytes		description
//							string 1 : long filename (codepage or unicode), 0 terminated
//							string 2 : 8.3 filename, 0 terminated
//								(string2 is optional, there is no string2 if length of string1 is <= 8)
// DWORD	4 bytes		---
// ]
//
// Windows XP
// [
// [Record] =
// DWORD	4 bytes		length of record (those 4 bytes are included)
// DWORD	4 bytes		sorted index (0-based), special value : -5 if never sorted (appended at tail)
// WORD		2 bytes		key1 : is a length (unsure at the moment a length of what)
// WORD		2 bytes		key2
//							bit 1 = 1 (url) 0 (folder)
//							bit 2 = 1 (string 1 encoding = unicode) 0 (string 1 encoding = codepage)
// DWORD	4 bytes		---
// DWORD	4 bytes		id
// WORD		2 bytes		= 0010 if that's a url, 0020 if that's a folder (mimics key2)
// BYTE		n bytes		description
//							string 1 : 8.3 filename (codepage or unicode encoding), 0 terminated
// BYTE     [1 byte]         optional 0 if string 1 ends at an uneven address
// BYTE     20 bytes	dummy bytes
//							string 2 : long filename (unicode encoding), 0 terminated
// DWORD	4 bytes		---
// ]
//
//

BOOL CFavorites::ExtractFavorites(HKEY hParentKey,
								  LPTSTR szRegKeyPath,
								  LPTSTR szFilePath,
								  CFavorite** ppFavorites,
								  BOOL bResolveUrl,
								  BYTE* buffer,
								  DWORD nLength)
{
	*ppFavorites = NULL; // default return value

	if (!buffer || nLength == 0)
	{
		ExtractFavoritesFromFolders(szFilePath, ppFavorites, bResolveUrl);
		return TRUE;
	}

	DWORD* pdword_buffer = (DWORD*) buffer;

	// read header
	//
	DWORD nTotalLength = pdword_buffer[2];
	DWORD nRecords = pdword_buffer[4];

	if (nRecords == 0) 
		return TRUE;

	CFavorite* pArrFavs = new CFavorite[nRecords];
	if ( !pArrFavs )
		return FALSE; // out of memory

	BYTE* p = buffer + 20;

	// read records one by one
	//
	for (DWORD i = 0; i < nRecords; i++)
	{

		DWORD length = *( (DWORD*)p );
		DWORD sortedindex = *( (DWORD*)(p+4) );
		if (sortedindex == 0xFFFFFFFB) // -5 = folder not sorted, all urls are as listed as is
			sortedindex = i;
		WORD  key1 = *( (WORD*)(p+8) );
		WORD  key2 = *( (WORD*)(p+10) );
		DWORD d1 = *( (DWORD*)(p+12) );
		DWORD id = *( (DWORD*)(p+16) );
		WORD  stringlength = *( (WORD*)(p+20) );

		BOOL bUrl = (key2 & 0x0002) ? TRUE : FALSE; // url or folder
		BOOL bUnicode = (key2 & 0x0004) ? TRUE : FALSE; // unicode encoding or codepage encoding
		
		if (sortedindex < nRecords)
		{
			pArrFavs[sortedindex].bType = bUrl;


			TCHAR szUrlPath[MAX_PATH];
			_tcscpy(szUrlPath, szFilePath);
			_tcscat(szUrlPath, "\\");

			if ( !AmIRunningOnXP() ) // I am not running on top of a XP kernel
			{
				if (bUnicode)
				{
					int cch = ::WideCharToMultiByte(CP_ACP, 0, (OLECHAR*)( p + 22 ), -1, 
													NULL, 0, NULL, NULL); 
					::WideCharToMultiByte(CP_ACP, 0, (OLECHAR*)( p + 22 ), -1, 
										pArrFavs[sortedindex].szPath, cch, NULL, NULL); 
				}
				else
				{
					_tcscpy(pArrFavs[sortedindex].szPath, (char*)( p + 22 ));
				}
				_tcscat(szUrlPath, pArrFavs[sortedindex].szPath);
				_tcscpy(pArrFavs[sortedindex].szPath, szUrlPath);
			}
			else // Windows XP kernel
			{
				// we are only interested in string2 (string1 is often 8.3 encoded)
				BYTE* purl = p + 22;

				if (bUnicode)
				{
					long n = wcslen( (LPWSTR)purl ) + sizeof(WCHAR);
					purl += n;
				}
				else
				{
					long n = strlen( (LPCSTR) purl ) + sizeof(CHAR);
					purl += n;
					if (n % 2)
						purl++; // make sure to take into account that we are at an uneven position
				}

				// pass dummy bytes
				purl += 20;

				int cch = ::WideCharToMultiByte(CP_ACP, 0, (OLECHAR*)( purl ), -1, 
												NULL, 0, NULL, NULL); 

				::WideCharToMultiByte(CP_ACP, 0, (OLECHAR*)( purl ), -1, 
									pArrFavs[sortedindex].szPath, cch, NULL, NULL); 

				_tcscat(szUrlPath, pArrFavs[sortedindex].szPath);
				_tcscpy(pArrFavs[sortedindex].szPath, szUrlPath);
			}
			
			// should we resolve the url?
			if (bUrl && bResolveUrl)
			{
				LPTSTR szUrl = NULL;
				ResolveInternetShortcut(szUrlPath, &szUrl);

				if (szUrl)
					_tcscpy(pArrFavs[sortedindex].szUrl, szUrl);

				m_pMalloc->Free(szUrl);
			}

		}

		p += length;

		if (p >= buffer + nLength)
			break; // avoid access violation

	} // for i

	// now make a chain out of these favorites
	//
	CFavorite* pCur = NULL;

	for (i = 0; i < nRecords; i++)
	{
		CFavorite* p = &pArrFavs[i];
		if (!p) continue;

		if (p->szPath[0] == '\0')
			continue;

		CFavorite* pNew = new CFavorite(p);
		if (!pNew)
			continue; // out of memory, oh my!

		// first item ?
		if (!pCur)
		{
			pCur = pNew;
			*ppFavorites = pCur; // return value
		}
		else // no, chain the item then
		{
			pCur->pNext = pNew;
			pCur = pNew;
		}

	} // for all favorite records

	delete [] pArrFavs;

	// finally add all folders and links found in the %FAVORITES% folder, that we didn't
	// find in the registry because no manual sort has occured yet.
	//

	return ExtractFavoritesFromFolders(szFilePath,
										ppFavorites,
										bResolveUrl);
}


BOOL CFavorites::ExtractFavoritesFromFolders(LPTSTR szFilePath,
											CFavorite** ppFavorites,
											BOOL bResolveUrl)
{

	HANDLE hFind;
	WIN32_FIND_DATA fd;

	TCHAR szFolderPath[MAX_PATH], szFolderPathWildcards[MAX_PATH], szUrlPath[MAX_PATH];
	_tcscpy(szFolderPath, szFilePath);
	if (szFolderPath[_tcslen(szFolderPath) - 1] != '\\')
		_tcscat(szFolderPath, "\\");

	_tcscpy(szFolderPathWildcards, szFolderPath);
	_tcscat(szFolderPathWildcards,"*.*");

	if ((hFind = ::FindFirstFile(szFolderPathWildcards,&fd))!=INVALID_HANDLE_VALUE)
	{
		do
		{
			if (_tcscmp(fd.cFileName,".")!=0 &&
				_tcscmp(fd.cFileName,"..")!=0 )
			{
				if (_tcsicmp(fd.cFileName, "Desktop.ini") == 0)
					continue; // we don't need this file !

				BOOL bUrl = (fd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) == 0;

				_tcscpy(szUrlPath, szFolderPath);
				_tcscat(szUrlPath, fd.cFileName);

				CFavorite* pLastFav = NULL;

				// do we know it already?
				//
				if (*ppFavorites)
				{
					CFavorite* pFav = *ppFavorites;
					if ( pFav->FindOccurence(szUrlPath, &pLastFav) )
						continue;
				}

				// create a new instance then
				//
				CFavorite* pFav = new CFavorite();
				if (!pFav)
					continue; // out of memory

				_tcscpy(pFav->szPath, szUrlPath);
				pFav->bType = bUrl;

				// should we resolve the url?
				if (bUrl && bResolveUrl)
				{
					LPTSTR szUrl = NULL;
					ResolveInternetShortcut(szUrlPath, &szUrl);

					if (szUrl)
						_tcscpy(pFav->szUrl, szUrl);

					m_pMalloc->Free(szUrl);
				}

				// add the favorite to the chain
				//
				if (pLastFav)
					pLastFav->pNext = pFav;
				else
				{
					*ppFavorites = pFav;
				}


			}
		}
		while (::FindNextFile(hFind,&fd));

		::FindClose(hFind);
	}

	return TRUE;
}


void CFavorites::GetFavoritesRegPath(/*out*/LPTSTR szFavoriteRegPath)
{
	_tcscpy(szFavoriteRegPath, "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\MenuOrder\\Favorites");
}


void CFavorites::GetFavoritesFilePath(/*out*/LPTSTR szFavoritePath)
{
	::SHGetSpecialFolderPath(NULL,
							 szFavoritePath,
							 CSIDL_FAVORITES,
							 FALSE);
}


// use the shell url parser to resolve what's the .url file actually targets
void CFavorites::ResolveInternetShortcut(LPTSTR szPath, LPTSTR* lpszURL)
{
	*lpszURL = NULL;  // Assume failure
	
	IUniformResourceLocator* pUrlLink = NULL;
	HRESULT hr = ::CoCreateInstance(CLSID_InternetShortcut, NULL, CLSCTX_INPROC_SERVER,
                                 IID_IUniformResourceLocator, (void**)&pUrlLink);
	if (FAILED(hr))
		return;

	IPersistFile* pPersistFile = NULL;
	
	hr = pUrlLink->QueryInterface(IID_IPersistFile, (LPVOID*)&pPersistFile);
	if (SUCCEEDED(hr))
	{
		// Ensure that the string is Unicode. 
		WCHAR wsz[MAX_PATH];  
		::MultiByteToWideChar(CP_ACP, 0, szPath, -1, wsz, MAX_PATH);
		
		// Load the Internet Shortcut from persistent storage.
		hr = pPersistFile->Load(wsz, STGM_READ);
		if (SUCCEEDED(hr))
			hr = pUrlLink->GetURL(lpszURL);
		
		pPersistFile->Release();
	}
	
	pUrlLink->Release();
} 


void CFavorites::CheckOS()
{
	OSVERSIONINFOEX osvi;

	// Try calling GetVersionEx using the OSVERSIONINFOEX structure.
	// If that fails, try using the OSVERSIONINFO structure.
	
	::ZeroMemory(&osvi, sizeof(OSVERSIONINFOEX));
	osvi.dwOSVersionInfoSize = sizeof(OSVERSIONINFOEX);
	
	if( !::GetVersionEx ((OSVERSIONINFO *) &osvi) )
	{
		osvi.dwOSVersionInfoSize = sizeof (OSVERSIONINFO);
		if (! ::GetVersionEx ( (OSVERSIONINFO *) &osvi) ) 
		{
			m_bRunningOnXP = FALSE;
			return;
		}
	}
	
	switch (osvi.dwPlatformId)
	{
		// Test for the Windows NT product family.
		case VER_PLATFORM_WIN32_NT:
			if ( osvi.dwMajorVersion == 5 && osvi.dwMinorVersion > 0)
			{
				// Windows 2000 : osvi.dwMinorVersion == 0
				// Windows Server 2003 : osvi.dwMinorVersion = 2
				// Windows XP : osvi.dwMinorVersion == 1
				m_bRunningOnXP = TRUE;
				return;
			}
	}

	m_bRunningOnXP = FALSE;
}

BOOL CFavorites::AmIRunningOnXP()
{
	return m_bRunningOnXP;
}
