

#pragma once


// declaration for class CFavorite //////////////////////////////////////////
//
//
//
class CFavorite
{
public:
	TCHAR szPath[MAX_PATH];
	BOOL bType; // TRUE = url, FALSE = folder
	TCHAR szUrl[INTERNET_MAX_URL_LENGTH];
	CFavorite* pNext; // chain to the next favorite

	CFavorite();
	CFavorite(CFavorite *pSrc);
	~CFavorite();

	BOOL FindOccurence(LPTSTR szPathToFind, CFavorite** ppLastFav);
};





// declaration for class CFavorites //////////////////////////////////////////
//
// this class extracts IEfavorites from the user profile
//
//
class CFavorites
{

	// Members
	//
protected:
	IMalloc *m_pMalloc;
	BOOL m_bRunningOnXP;

	// Construction
public:
	CFavorites();
	virtual ~CFavorites();

	BOOL ExtractFavorites(CFavorite** ppFavorites,
						  BOOL bResolveUrl); // root level
	BOOL ExtractFavorites(LPTSTR szRegKeyPath,
						  LPTSTR szFilePath,
						  CFavorite** ppFavorites,
						  BOOL bResolveUrl); // another level
	BOOL ExtractFavorites(HKEY hParentKey,
							LPTSTR szRegKeyPath,
							LPTSTR szFilePath,
							CFavorite** ppFavorites,
							BOOL bResolveUrl); // another level
	BOOL ExtractFavorites(HKEY hParentKey, 
							LPTSTR szRegKeyPath,
							LPTSTR szFilePath,
							CFavorite** ppFavorites,
							BOOL bResolveUrl,
							BYTE* buffer,
							DWORD nLength); // another level
	BOOL ExtractFavoritesFromFolders(LPTSTR szFilePath,
							CFavorite** ppFavorites,
							BOOL bResolveUrl);

	void GetFavoritesRegPath(/*out*/LPTSTR szFavoriteRegPath);
	void GetFavoritesFilePath(/*out*/LPTSTR szFavoritePath);

	// Helpers
protected:
	void ResolveInternetShortcut(LPTSTR szPath, LPTSTR* szUrl);
	
	void CheckOS();
	BOOL AmIRunningOnXP();
};