

#include "stdafx.h"
#include "AString.h"


// global instance
AStringManager _mgr;


AString::AString() 
{ 
	m_str = NULL;
}
AString::AString(char *szInputSource) 
{ 
	m_str = NULL;
	if (szInputSource)
		Copy(szInputSource);
}
AString::AString(const AString &szInputSource) 
{ 
	m_str = NULL;
	Copy(szInputSource.GetData());
}
AString::~AString()
{
	Empty();
}

// Methods
void AString::Empty()
{
	m_str = NULL;
}

long AString::GetLength() const
{ 
	return m_str ? strlen(m_str) : 0; 
}

bool AString::IsEmpty() const
{
	return GetLength()==0;
}

char* AString::GetData() const
{
	return (char*) m_str;
}

char* AString::GetBuffer(int index)
{
	return & m_str[index];
}

AString::operator char*()
{
	return GetData();
}

char AString::GetAt(long nIndex)
{
	return nIndex<GetLength() ? m_str[nIndex] : 0;
}

char AString::RawGetAt(long nIndex) // no sanity check, use only in performance issues
{
	return m_str[nIndex];
}

char AString::operator[](long nIndex)
{
	return GetAt(nIndex);
}

void AString::SetAt(long nIndex, char ch)
{
	// new string
	// TODO

	if (nIndex<GetLength())
		m_str[nIndex] = ch;
}

void AString::RawSetAt(long nIndex, char ch) // no sanity check, use only in performance issues
{
	// new string
	// TODO

	m_str[nIndex] = ch;
}

void AString::Copy(char *szInputSource)
{
	Empty();
	if (!szInputSource) return;

	m_str = _mgr.S(szInputSource);
}

void AString::Copy(const AString &szInputSource)
{
	Copy( szInputSource.GetData() );
}

void AString::operator =(char *szInputSource)
{
	Copy( szInputSource );
}

void AString::operator =(const AString &szInputSource)
{
	Copy( szInputSource );
}

void AString::ToLower()
{
	if (GetLength()>0)
		strlwr(m_str);
}

void AString::ToUpper()
{
	if (GetLength()>0)
		strupr(m_str);
}

bool AString::Compare(const char *szCompareString)
{
	if (!GetData()) return false;

	return szCompareString ? (strcmp(GetData(),szCompareString)==0) : NULL;
}

bool AString::Compare(AString &szCompareString)
{
	if (!GetData()) return false;

	return strcmp(GetData(),szCompareString.GetData())==0;
}

bool AString::CompareNoCase(const char *szCompareString)
{
	if (!GetData()) return false;

	return szCompareString ? (stricmp(GetData(),szCompareString)==0) : NULL;
}

bool AString::CompareNoCase(AString &szCompareString)
{
	if (!GetData()) return false;

	return stricmp(GetData(),szCompareString.GetData())==0;
}

bool AString::operator ==(AString &szCompareString)
{
	return Compare(szCompareString);
}

long AString::Find(char *szStringToFind, long nStartIndex) // find string
{
	if (szStringToFind && nStartIndex<GetLength())
	{
		char *szResult = strstr(m_str+nStartIndex, szStringToFind);
		return szResult ? (long)(szResult - m_str) : -1;
	}
	else
		return -1;
}

long AString::Find(char sCharToFind, long nStartIndex) // find char
{
	char szTemp[2];
	szTemp[0] = sCharToFind;
	szTemp[1] = '\0';

	return Find(szTemp, nStartIndex);
}

long AString::FindNoCase(char *szStringToFind, long nStartIndex) // find string (without case)
{
	if (!szStringToFind)
		return -1;

	AString szTempLower = GetData();
	szTempLower.ToLower();
	AString szStringToFindLower = szStringToFind;
	szStringToFindLower.ToLower();

	return szTempLower.Find(szStringToFindLower.GetData(), nStartIndex);
}

long AString::FindNoCase(char szCharToFind, long nStartIndex) // find char (without case)
{
	char szTemp[2];
	szTemp[0] = szCharToFind;
	szTemp[1] = '\0';

	return FindNoCase(szTemp, nStartIndex);
}

long AString::ReverseFind(char ch, long nStartIndex)
{
	if (nStartIndex<GetLength())
	{
		char *szResult = strrchr(m_str+nStartIndex, ch);
		return szResult ? (long)(szResult - m_str) : -1;
	}
	else
		return -1;
}

AString AString::Left(long nCount)
{
	AString temp;
	char *szTemp=(char*) malloc(nCount+1);
	szTemp[0]='\0';
	if (nCount>0 && GetLength()>0)
	{
		strncat(szTemp, m_str, nCount>GetLength() ? GetLength() : nCount);
		strcat(szTemp, "\0");
	}
	temp = szTemp;
	free(szTemp);
	return temp;
}

AString AString::ExcludeLeft(long nCount) // remove first nCount chars
{
	return Right(GetLength()-nCount);
}

AString AString::Mid(long nIndex, long nCount)
{
	AString temp;
	char *szTemp=(char*) malloc(nCount+1);
	szTemp[0]='\0';
	if (nIndex>=0 && nCount>0 && GetLength()>0)
	{
		strncat(szTemp, m_str+nIndex, (nCount+nIndex)>GetLength() ? GetLength()-nIndex : nCount);
		strcat(szTemp, "\0");
	}
	temp = szTemp;
	free(szTemp);
	return temp;
}

AString AString::Right(long nCount)
{
	return Mid(GetLength()-nCount, nCount);
}

void AString::InternalLeft(long nCount) //  applies to *this* object
{
	AString t;
	t = Left(nCount);
	*this = t;
}

void AString::InternalExcludeLeft(long nCount) // remove first nCount chars,  applies to *this* object
{
	InternalRight(GetLength()-nCount);
}

void AString::InternalMid(long nIndex, long nCount) //  applies to *this* object
{
	AString t;
	t = Mid(nIndex,nCount);
	*this = t;
}

void AString::InternalRight(long nCount) //  applies to *this* object
{
	InternalMid(GetLength()-nCount, nCount);
}


//AString st = sParams.Tokenize(",",iStart);

AString AString::Tokenize(char *szTokens, long &nStartIndex)
{
	AString s;
	if (nStartIndex<0 || nStartIndex>=GetLength())
		return s;

	if (strlen(szTokens)==0)
		return s;

	char c = szTokens[0];
	// long Find(long nStartIndex, char *szStringToFind) // find string
	long nIndex = Find(c, nStartIndex);
	if (nIndex<0)
	{
		s = ExcludeLeft(nStartIndex); // copy current string
		nStartIndex = GetLength();
	}
	else
	{
		s = Mid(nStartIndex,nIndex-nStartIndex);
		nStartIndex = nIndex+1;
	}

	return s;
}

void AString::Append(char *szAdditionalString)
{
	if (!m_str)
		Copy(szAdditionalString);
	else
	{
		long n = strlen(szAdditionalString);
		if (n>0)
		{
			long nCurLength = GetLength();
			char *tempbuf = (char*) _alloca( nCurLength );
			memcpy(tempbuf, m_str, nCurLength);
			m_str = (char*) realloc (m_str, nCurLength+n+1 );
			memcpy(m_str, tempbuf, nCurLength);
			m_str[nCurLength]='\0'; // force EOL
			strcat(GetData(),szAdditionalString);
		}
	}
}

void AString::Append(AString &szAdditionalString)
{
	if (!szAdditionalString.IsEmpty())
		Append( szAdditionalString.GetData() );
}

void AString::Append(char sAdditionalChar)
{
	char szAdditionalString[2];
	szAdditionalString[0] = sAdditionalChar;
	szAdditionalString[1] = '\0';
	Append(szAdditionalString);
}

void AString::operator +=(AString &szAdditionalString)
{
	Append(szAdditionalString);
}

void AString::operator +=(char *szAdditionalString)
{
	Append(szAdditionalString);
}

void AString::operator +=(char sAdditionalChar)
{
	Append(sAdditionalChar);
}

AString AString::operator +(AString &szAdditionalString)
{
	AString szTemp = *this;
	szTemp.Append(szAdditionalString);
	return szTemp;
}

AString AString::operator +(char *szAdditionalString)
{
	AString szTemp = *this;
	szTemp.Append(szAdditionalString);
	return szTemp;
}

AString AString::operator +(char sAdditionalChar)
{
	AString szTemp = *this;
	szTemp.Append(sAdditionalChar);
	return szTemp;
}


void AString::TrimLeft(char ch)
{
	if (IsEmpty())
		return;
	
	long nSize = GetLength();
	long nAmount = 0;
	bool bContinue = true;
	for (long i=0; i<nSize && bContinue; i++)
	{
		if (RawGetAt(i)==ch)
			nAmount++;
		else
			bContinue = false;
	}

	if (!bContinue || nAmount>0)
		InternalExcludeLeft( nAmount );
}

void AString::TrimRight(char ch)
{
	if (IsEmpty())
		return;
	
	long nSize = GetLength();
	long nAmount = 0;
	bool bContinue = true;
	for (long i=0; i<nSize && bContinue; i++)
	{
		if (RawGetAt(nSize-1-i)==ch)
			nAmount++;
		else
			bContinue = false;
	}

	if (!bContinue || nAmount>0)
		InternalLeft( GetLength()-nAmount );
}

void AString::Trim(char ch)
{
	TrimLeft(ch);
	TrimRight(ch);
}

long AString::GetNumber()
{
	if (IsEmpty())
		return 0L;

	long longValue = 0;
	char *c = strpbrk(GetData(), "0123456789.,-+");
	if (c) sscanf(c, "%ld", &longValue); 
	return longValue;
}

float AString::GetFloat()
{
	if (IsEmpty())
		return 0.0f;

	float floatValue = 0;
	char *c = strpbrk(GetData(), "0123456789.,-+");
	if (c) sscanf(c, "%f", &floatValue); 
	return floatValue;
}


void AString::ReplaceChar(char ch, char sReplacementChar)
{
	if (IsEmpty())
		return;

	// new string
	// TODO


	long nSize = GetLength();
	long nIndex=0;
	long nIndex2;
	while ( nIndex<nSize && (nIndex2=Find(ch, nIndex))>-1 )
	{
		RawSetAt( nIndex2, sReplacementChar);

		nIndex = ++nIndex2; // ensure no infinite loop trap
		
		// loop
	}
}

void AString::ReplaceCharWithString(char ch, char *szReplacementString) // szReplacementString==NULL allowed
{
	if (IsEmpty())
		return;

	AString szTemp;
	long nSize = GetLength();
	long nIndex=0;
	long nIndex2;
	while ( nIndex<nSize && (nIndex2=Find(ch, nIndex))>-1 )
	{
		// copy first portion of string
		if (nIndex2>nIndex)
		{
			szTemp += Mid(nIndex, nIndex2-nIndex);
		}

		// then copy replacement string
		if (szReplacementString)
		{
			szTemp += szReplacementString;
		}

		nIndex = ++nIndex2; // ensure no infinite loop trap
		
		// loop
	}

	// don't forget to copy the remainder of the input string, if any
	if (nIndex<nSize)
		szTemp += ExcludeLeft(nIndex);

	*this = szTemp;
}

void AString::ReplaceCharWithString(char ch, AString &szReplacementString)
{
	ReplaceCharWithString(ch, szReplacementString.GetData() );
}


void AString::Format(LPSTR pszFormat, ...) // do not use, m_str does not have the right buffer allocated
{ // missing here is a preliminary loop that sums the amount of bytes required to expand pszFormat according to argList %s, %d, ...
	va_list argList;
	va_start(argList, pszFormat);
	vsprintf(m_str, pszFormat, argList ); 
	va_end(argList);
}

/*	BSTR AllocSysString() const
{
#if defined(_UNICODE) || defined(OLE2ANSI)
	BSTR bstr = ::SysAlloAStringLen(m_str, GetLength());
#else
	int nLen = ::MultiByteToWideChar(CP_ACP, 0, m_str, GetLength(), NULL, NULL);
	BSTR bstr = ::SysAlloAStringLen(NULL, nLen);
	::MultiByteToWideChar(CP_ACP, 0, m_str, GetLength(), bstr, nLen);
#endif

	return bstr;
}*/












///////////////////////////HASH CODE TABLE ////////////////////////////////////////////////


#define XMLINIT_SIZE 64

static int Xmlkeyeq(const char *s1, char *s2)
{
  return strcmp(s2,s1);
}

static unsigned long Xmlhash(const char *s)
{
  unsigned long h = 0;
  while (*s)
    h = (h << 5) + h + (unsigned char)*s++;
  return h;
}

char *XmlhashTableLookup(XMLHASH_TABLE *table, const char *name, const void *ptr)
{
  size_t i;
  if (table->size == 0) // non initialized table
  {
    table->v = (XMLNAMED**) calloc(XMLINIT_SIZE, sizeof(XMLNAMED *));
    if (!table->v)
      return NULL;
    table->size = XMLINIT_SIZE;
    table->usedLim = XMLINIT_SIZE / 2;
    i = Xmlhash(name) & (table->size - 1);
  }
  else // find name in the table
  {
    unsigned long h = Xmlhash(name);
    for (i = h & (table->size - 1); table->v[i]; i == 0 ? i = table->size - 1 : --i) 
	{
      if (Xmlkeyeq(name, table->v[i]->name))
		return table->v[i]->name; // name found
    }

	// not found, prepare addition to the table
    if (table->used == table->usedLim) 
	{
      // check for overflow
      size_t newSize = table->size * 2;
      XMLNAMED **newV = (XMLNAMED**) calloc(newSize, sizeof(XMLNAMED *));
      if (!newV)
		return NULL;
      for (i = 0; i < table->size; i++)
		if (table->v[i]) 
		{
			size_t j;
			for (j = Xmlhash(table->v[i]->name) & (newSize - 1);
					newV[j];
					j == 0 ? j = newSize - 1 : --j)
				;

			newV[j] = table->v[i];
		}
      free(table->v);
      table->v = newV;
      table->size = newSize;
      table->usedLim = newSize/2;
      for (i = h & (table->size - 1);  table->v[i];  i == 0 ? i = table->size - 1 : --i)
			;
    }
  }

  table->v[i] = new XMLNAMED(); // was (in original code) table->v[i] = (XMLNAMED*) calloc(1, sizeof(XMLNAMED) );
  if (!table->v[i])
    return 0;

  table->v[i]->name = (char*) malloc( strlen(name)+1 ); // name is const char*
  if ( table->v[i]->name )
	strcpy(table->v[i]->name, name);

  table->v[i]->ptr = (void*)ptr;
  (table->used)++;
  
  return table->v[i]->name;
}

void XmlhashTableDestroy(XMLHASH_TABLE *table)
{
  for (size_t i = 0; i < table->size; i++) 
    delete table->v[i];

  if (table->v)
	free(table->v);
}

void XmlhashTableInit(XMLHASH_TABLE *p)
{
  p->size = 0;
  p->usedLim = 0;
  p->used = 0;
  p->v = NULL;
}

long XmlhashTableSize(XMLHASH_TABLE *p)
{
	return p? p->used : 0;
}


XMLNAMED *XmlhashTableFirstItem(XMLHASH_TABLE_ITER *iter, XMLHASH_TABLE *p)
{
	if (!iter)
		return NULL;

	iter->p = p->v;
	iter->end = iter->p + p->size;

	return XmlhashTableNextItem(iter, p);
}

XMLNAMED *XmlhashTableNextItem(XMLHASH_TABLE_ITER *iter, XMLHASH_TABLE *p)
{
	while (iter->p != iter->end) 
	{
		XMLNAMED *tem = *(iter->p)++;
		if (tem)
			return tem;
	}
	return NULL;
}












AStringManager::AStringManager()
{
	Init();
}
AStringManager::~AStringManager()
{
	Destroy();
}

void AStringManager::Init()
{
	XmlhashTableInit(&m_hashTable);
}
void AStringManager::Destroy()
{
	// free memory
	XMLHASH_TABLE_ITER	iter;

	XMLNAMED *pBlock = XmlhashTableFirstItem(&iter,&m_hashTable);
	while ( pBlock )
	{
		free( pBlock->name );

		pBlock = XmlhashTableNextItem(&iter,&m_hashTable);
	}

	XmlhashTableDestroy(&m_hashTable);
}

char* AStringManager::S(char *p) // add or get ptr
{
	if (!p) return NULL;

	return XmlhashTableLookup(&m_hashTable, p, NULL);
}


