
#pragma once

#include <stdio.h>
#include <string.h>
#include <malloc.h> // for _alloca (allocation on stack)


// --------------------------------------------------------------------------------
//
//
//	AString class : exposes the equivalent of the MFC API, without the MFC.
//
//
//
class AString
{
	// Members
protected:
	char *m_str;

	// Constructor/Destructor
public:
	AString() ;
	AString(char *szInputSource);
	AString(const AString &szInputSource);
	~AString();

// Methods
public:
	void Empty();
	long GetLength() const;
	bool IsEmpty() const;
	char *GetData() const;
	char *GetBuffer(int index);
	operator char*();
	char GetAt(long nIndex);
	char RawGetAt(long nIndex);
	char operator[](long nIndex);
	void SetAt(long nIndex, char ch);
	void RawSetAt(long nIndex, char ch);
	void Copy(char *szInputSource);
	void Copy(const AString &szInputSource);
	void operator =(char *szInputSource);
	void operator =(const AString &szInputSource);
	void ToLower();
	void ToUpper();
	bool Compare(const char *szCompareString);
	bool Compare(AString &szCompareString);
	bool CompareNoCase(const char *szCompareString);
	bool CompareNoCase(AString &szCompareString);
	bool operator ==(AString &szCompareString);
	long Find(char *szStringToFind, long nStartIndex);
	long Find(char sCharToFind, long nStartIndex);
	long FindNoCase(char *szStringToFind, long nStartIndex);
	long FindNoCase(char szCharToFind, long nStartIndex);
	long ReverseFind(char ch, long nStartIndex);
	AString Left(long nCount);
	AString ExcludeLeft(long nCount);
	AString Mid(long nIndex, long nCount);
	AString Right(long nCount);
	void InternalLeft(long nCount);
	void InternalExcludeLeft(long nCount);
	void InternalMid(long nIndex, long nCount);
	void InternalRight(long nCount);
	AString Tokenize(char *szTokens, long &nStartIndex);
	void Append(char *szAdditionalString);
	void Append(AString &szAdditionalString);
	void Append(char sAdditionalChar);
	void operator +=(AString &szAdditionalString);
	void operator +=(char *szAdditionalString);
	void operator +=(char sAdditionalChar);
	AString operator +(AString &szAdditionalString);
	AString operator +(char *szAdditionalString);
	AString operator +(char sAdditionalChar);
// binary + operator (global, with const parameters)
	friend AString operator+(const AString &sz1, const AString &sz2)
	{
		AString s = sz1;
		s += (AString&)sz2;
		return s;
	}
	friend AString operator+(AString &sz1, const char *sz2)
	{
		AString s = sz1;
		s += (char*)sz2;
		return s;
	}
	friend AString operator+(const char *sz1, AString &sz2)
	{
		AString s = (char*)sz1;
		s += sz2;
		return s;
	}

	void TrimLeft(char ch=' ');
	void TrimRight(char ch=' ');
	void Trim(char ch=' ');
	long GetNumber();
	float GetFloat();
	void ReplaceChar(char ch, char sReplacementChar);
	void ReplaceCharWithString(char ch, char *szReplacementString);
	void ReplaceCharWithString(char ch, AString &szReplacementString);
	void Format(LPSTR pszFormat, ...);
/*	BSTR AllocSysString() const;*/

}; 

typedef AString &RString;





///////////////////////////HASH CODE TABLE ////////////////////////////////////////////////

typedef struct {
  char *name;
  void *ptr;
} XMLNAMED;

typedef struct {
  XMLNAMED **v;
  size_t size;
  size_t used;
  size_t usedLim;
} XMLHASH_TABLE;

typedef struct {
  XMLNAMED **p;
  XMLNAMED **end;
} XMLHASH_TABLE_ITER;

char *XmlhashTableLookup(XMLHASH_TABLE *table, const char *name, const void *ptr);
void XmlhashTableInit(XMLHASH_TABLE *);
void XmlhashTableDestroy(XMLHASH_TABLE *);

long XmlhashTableSize(XMLHASH_TABLE *p);
XMLNAMED *XmlhashTableFirstItem(XMLHASH_TABLE_ITER *iter, XMLHASH_TABLE *p);
XMLNAMED *XmlhashTableNextItem(XMLHASH_TABLE_ITER *iter, XMLHASH_TABLE *p);








class AStringManager
{
protected:
	XMLHASH_TABLE m_hashTable;

public:
	AStringManager();
	virtual ~AStringManager();

	void Init();
	void Destroy();

	char *S(char *); // add or get ptr
};


